/** @file

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2011 - 2016 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef _PCI_BOARD_H_
#define _PCI_BOARD_H_

#include "Tiano.h"

#pragma pack(push, 1)

typedef struct {
  UINT8  PciBusNumber;
  UINT8  DeviceNumber;   // Valid in lower 5 bits
  UINT8  IntA_ApicIntIn; // APIC input# (for example: 16~23)
  UINT8  IntA_ApicId;    // IO APIC ID
  UINT8  IntB_ApicIntIn;
  UINT8  IntB_ApicId;
  UINT8  IntC_ApicIntIn;
  UINT8  IntC_ApicId;
  UINT8  IntD_ApicIntIn;
  UINT8  IntD_ApicId;
  UINT8  Reserved;
} MP_ROUTING_STRUCT;

typedef struct {
  UINT32 ApicAddress;
  UINT8  ApicId;
  UINT8  Reserved;
} MP_APIC_STRUCTI;

typedef struct {
  UINT8  PciBusNumber;
  UINT8  DeviceNumber; // Vaild in upper 5 bits
  UINT8  IntA_Reg;     // Chipset register (for example: 60~63, 68~6B)
  UINT16 IntA_Irqs;    // Bitmap of IRQs Routable PIN
  UINT8  IntB_Reg;
  UINT16 IntB_Irqs;
  UINT8  IntC_Reg;
  UINT16 IntC_Irqs;
  UINT8  IntD_Reg;
  UINT16 IntD_Irqs;
  UINT8  PhysicalSlot;
  UINT8  Reserved;
} PIRQ_ROUTING_STRUCT;

#pragma pack(pop)

#endif
